/* Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Andres Aguirre	   27/03/07 	Original
 ********************************************************************/

#include "user\adminModule.h"

/** V A R I A B L E S ********************************************************/
#pragma udata
//AM_PACKET adminDataPacket;
byte* sendBufferAdmin;
byte adminHandler;

/** P R I V A T E  P R O T O T Y P E S ***************************************/

/** D E C L A R A T I O N S **************************************************/
#pragma code sys


void adminModuleInit(void){
	//inicializacion del sistema
	adminHandler=0; //hardcore, el admin siempre atiende el handler 0
	//agrego mi buffer en el handler module	
//	setHandlerReceiveBuffer(adminHandler, (byte*)&adminDataPacket);
	//agrego mi funcion de Receive en el handler module
	setHandlerReceiveFunction(adminHandler,&adminReceived);
	//No hay funcion de pooling para modulo admin
	//res = addPollingFunction(&ProcessIO);
	sendBufferAdmin = getSharedBuffer(adminHandler);
}

void adminReceived(byte* recBuffPtr,byte len){
	byte adminCounter;
	byte endIn = nullEP, endOut = nullEP;
	byte userTableSize = 0;
    byte lineNumber = 0;
	char lineName[8];
	rom near char* tableDirec;
	pUserFunc dir;	
	void (*pUser)(byte);
	byte handler, response;
	byte j;
    adminCounter = 0;
mInitAllLEDs();
    switch(((AM_PACKET*)recBuffPtr)->CMD){
          case OPEN:
			  tableDirec = getUserTableDirection(((AM_PACKET*)recBuffPtr)->moduleId);
			  if(!existsTableEntry(tableDirec)){
			      dir = getModuleInitDirection(tableDirec);
				  //Si dir vale error es que no se encontro un modulo con nombre moduleId
				  if((byte)dir != ERROR){
					endIn = ((AM_PACKET*)recBuffPtr)->inEp;
					handler = newHandlerTableEntry(endIn,tableDirec);  
				  	//TODO Carlos tenes que chequear que handler no valga ERROR (ver defines.h)
				  	pUser = dir;
				  	pUser(handler); //hago el init ;)
				  	((AM_PACKET*)sendBufferAdmin)->handlerNumber = handler;
				  }else{
				   	 ((AM_PACKET*)sendBufferAdmin)->handlerNumber = ERROR;
				  }
			  }else{
			   	   ((AM_PACKET*)sendBufferAdmin)->handlerNumber = ERROR;
			  }		
              ((AM_PACKET*)sendBufferAdmin)->CMD = OPEN;
			  adminCounter=0x02; //1 byte para el campo CMD, otro para el handler 	      	
		      break;

          case CLOSE:
              handler  = ((AM_PACKET*)recBuffPtr)->handlerNumber;
			  response = removeHandlerTableEntry(handler);	
			  ((AM_PACKET*)sendBufferAdmin)->response = response;
			  ((AM_PACKET*)sendBufferAdmin)->CMD = CLOSE; 
			  adminCounter = 0x02; //1 byte para el campo CMD, otro para la respuesta
              break;

          case INIT:
              removeAllOpenModules();
			  ((AM_PACKET*)sendBufferAdmin)->CMD = INIT; 
			  adminCounter = 0x01; //1 byte para el campo CMD
              break;

          case MESSAGE:
              // me limito a solamente mandar el paquete que me genera el usuario mediante sendMes (ping)
              adminCounter = sizeof(((AM_PACKET*)recBuffPtr));
			  break;
              
          case LOAD:
              //Ver loaderModule.h
			  //loadModule(byte idModule, byte* binaryStream);
			  adminCounter = 0x01;
              break;

          case UNLOAD:
              adminCounter=0x03;
              break;

          case GET_USER_MODULES_SIZE:
              userTableSize = getUserTableSize();
			  ((AM_PACKET*)sendBufferAdmin)->CMD  = GET_USER_MODULES_SIZE;
			  ((AM_PACKET*)sendBufferAdmin)->size = userTableSize;
			  adminCounter=0x02;
              break;

		  case GET_USER_MODULES_LINE:
			  ((AM_PACKET*)sendBufferAdmin)->CMD  = GET_USER_MODULES_LINE;
			  lineNumber = ((AM_PACKET*)recBuffPtr)->line;
			  getModuleName(lineNumber, (char*)lineName);	
			  //memcpy(((AM_PACKET*)sendBufferAdmin)->lineName, lineName, 8); no anda, sera porque estan en espacios de memoria separados (RAM/ROM)?			
			  for (j = 0; j < 8; j++){       
			  	((AM_PACKET*)sendBufferAdmin)->lineName[j] = lineName[j];  
			  }
				adminCounter=0x09;
              break;

		   case CONFIGURE:
              handler  = ((AM_PACKET*)recBuffPtr)->handlerNumber;
			  response = configureHandlerTableEntry(handler);	
			  ((AM_PACKET*)sendBufferAdmin)->response = response;
			  ((AM_PACKET*)sendBufferAdmin)->CMD = CONFIGURE; 
			  adminCounter = 0x02; //1 byte para el campo CMD, otro para la respuesta
			  break;	

          default:
              break;

      }//end switch()
      if(adminCounter != 0){
          if(!mUSBGenTxIsBusy())
          	USBGenWrite2(adminHandler, adminCounter);
      }//end if

}//end adminReceived

void sendMes(char* mensaje, byte len){
	byte adminCounter, j;
	((AM_PACKET*)sendBufferAdmin)->CMD = MESSAGE;
	for (j = 0; j < len; j++){ 
		((AM_PACKET*)sendBufferAdmin)->texto[j] = mensaje[j];
	}
	adminCounter = len + 1; //sizeof(adminDataPacket);
    if(!mUSBGenTxIsBusy())
       	USBGenWrite2(adminHandler, adminCounter);
}

/*
void sendMes(char mensaje[8]){
	byte adminCounter, j;
	((AM_PACKET*)sendBufferAdmin)->CMD = MESSAGE;
	for (j = 0; j < 8; j++){ 
		((AM_PACKET*)sendBufferAdmin)->texto[j] = mensaje[j];
	}
	adminCounter = 9; //sizeof(adminDataPacket);
    if(!mUSBGenTxIsBusy())
       	USBGenWrite2(adminHandler,sendBufferAdmin,adminCounter);
}*/

/** EOF adminModule.c ***************************************************************/
 

